package pl.gda.pg.concurrency.locks;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LockDemo {
    Lock lockDeadA;
    Lock lockDeadB;
    Lock lockOkA;
    Lock lockOkB;
    Integer sharedResource = new Integer(10);

    class DeadlockingThread implements Runnable {
        int id;

        public DeadlockingThread(int id) {
            this.id = id;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(100);
                if (id == 1) {
                    lockDeadA.lock();
                    System.out.println("Lock dead A from thread " + id);
                    Thread.sleep(90);
                    lockDeadB.lock();
                } else {
                    lockDeadB.lock();
                    System.out.println("Lock dead B from thread " + id);
                    Thread.sleep(80);
                    lockDeadA.lock();

                }

                System.out.println("IMPOSSIBLE Lock write: thread " + id);
                sharedResource++;
            } catch (InterruptedException e) {
            } finally {
                lockDeadA.unlock();
                lockDeadB.unlock();
            }
            System.out.println("IMPOSSIBLE: thread " + id);
        }
    }

    class NonDeadlockingThread implements Runnable {
        int id;

        public NonDeadlockingThread(int id) {
            this.id = id;
        }

        @Override
        public void run() {
            Boolean tryLockA = false;
            Boolean tryLockB = false;
            try {
                if (id == 1) {
                    while (!(tryLockA && tryLockB)) {
                        Thread.sleep(100);
                        tryLockA = lockOkA.tryLock();
                        System.out.println("Lock ok A from thread " + id + " " + tryLockA);
                        Thread.sleep(90);
                        tryLockB = lockOkB.tryLock();
                        System.out.println("Lock ok B from thread " + id + " " + tryLockB);
                        if (!(tryLockA && tryLockB)) {
                            if (tryLockA) {
                                lockOkA.unlock();
                                System.out.println("Lock ok A released by thread " + id);
                            }
                            if (tryLockB) {
                                lockOkB.unlock();
                                System.out.println("Lock ok B released by thread " + id);
                            }
                        }
                    }
                } else {
                    while (!(tryLockA && tryLockB)) {
                        Thread.sleep(100);
                        tryLockB = lockOkB.tryLock();
                        System.out.println("Lock ok B from thread " + id + " " + tryLockB);
                        Thread.sleep(80);
                        tryLockA = lockOkA.tryLock();
                        System.out.println("Lock ok A from thread " + id + " " + tryLockA);
                        if (!(tryLockA && tryLockB)) {
                            if (tryLockA) {
                                lockOkA.unlock();
                                System.out.println("Lock ok A released by thread " + id);
                            }
                            if (tryLockB) {
                                lockOkB.unlock();
                                System.out.println("Lock ok B released by thread " + id);
                            }
                        }
                    }
                }
                System.out.println("Lock ok write: thread " + id);
                sharedResource++;
            } catch (InterruptedException e) {
                e.printStackTrace();
            } finally {
                lockOkA.unlock();
                lockOkB.unlock();
            }
            System.out.println("Finished lock ok: thread " + id);
        }
    }

    public void tryDeadlock() {
        lockDeadA = new ReentrantLock();
        lockDeadB = new ReentrantLock();
        new Thread(new DeadlockingThread(1)).start();
        new Thread(new DeadlockingThread(2)).start();
    }

    public void tryNonDeadlock() {
        lockOkA = new ReentrantLock();
        lockOkB = new ReentrantLock();
        new Thread(new NonDeadlockingThread(1)).start();
        new Thread(new NonDeadlockingThread(2)).start();
    }
}
